/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

vec3 hyper_pow(vec3 c, float n)
{
    float x2 = c.x * c.x;
    float y2 = c.y * c.y;
    float z2 = c.z * c.z;
    float r = sqrt(x2 + y2 + z2);
    float theta = atan(c.y / c.x);
    float phi = asin(c.z / r);
    float ntheta = n * theta;
    float nphi = n * phi;
    return pow(r, n) * vec3(cos(ntheta) * cos(nphi), sin(ntheta) * cos(nphi), sin(nphi));
}

mat3 rotationMatrix(vec3 axis, float angle)
{
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;
    
    return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);
}

void main(void)
{
    mat3 rot = rotationMatrix(vec3(1.0, 1.0, 1.0), iGlobalTime / 2.0);
    
	vec2 uv = gl_FragCoord.xy / iResolution.xx - vec2(0.5, 0.5 * iResolution.y / iResolution.x);
    
    uv *= 4.0;
    
    const int planes_count = 256;
    
    float color = 0.0;
    vec3 c;
    
    for(int plane = 0; plane <= planes_count; ++plane)
    {
        float depth = float(plane) / float(planes_count);
        c = vec3(uv.xy, 1.0 - 2.0 * depth);
        c = rot * c;
    	vec3 z = c;
        
        for(int i = 0; i < 4; ++i)
    	{
	        z = hyper_pow(z, 8.0) + c;
	    }
    
    	color = length(z) < 4.0 ? (1.0 - depth) : 0.0;
        
        if(color > 0.0)
        {
            break;
        }
    }
    
    color = pow(3.0, color) / 1.5 - 1.0;
    
	gl_FragColor = vec4(color);
}